﻿<%@ Page Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" Inherits="TBI_Instruments_MayoPortlandAdaptabilityInventory4" CodeFile="MayoPortlandAdaptabilityInventory4.aspx.cs"  %>

<%@ Import Namespace="VeteransAffairs.Registries.Business" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register TagPrefix="VA" TagName="TbiDiagnosisSelector" Src="~/controls/TbiDiagnosisSelector.ascx" %>



<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        .detailTable
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .detailTable td
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .requiredField 
        {
        	font-weight:bold;
        	color:#FF0000;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" ScriptMode="Release" runat="server">
    </asp:ScriptManager>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">

        <script type="text/javascript">
            Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
            Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

            function startRequest(sender, e) {
                //disable button during the AJAX call
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
            }
            function endRequest(sender, e) {
                //re-enable button once the AJAX call has completed
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
            }
        </script>
        <script type="text/javascript">
            $(document).ready(function() {

                // Disables 'Enter' Key from posting back on any input 
                // element ( textbox, radiolist, checkbox, etc )
                $('input').keydown(function(e) {
                    if (e.keyCode == 13) { return false; }
                });

                // Disables 'Enter' Key from posting back when no input 
                // element is in focus, and the enter key is pressed 
                $('div').keydown(function(e) {
                    if (e.keyCode == 13) { return false; }
                });

            }); // END $(document).ready(function()
        </script>
        <script type="text/javascript">
            $(document).ready(function () {
               $('input:text').keydown(function(e) {
                    //cancel enter to prevent errors
                    if (e.keyCode == 13)
                        return false;
                });

                //processPersonReporting_Click();
                //processRadioButtonQ_Click();

                window.onbeforeunload = function () {
                    //Save draft if timeout occurs
                    document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                   // return;
                }

            }); // END $(document).ready(function()

        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > Mayo-Portland Adaptability Inventory-4 (MPAI-4)"></asp:Label>
        </div>
    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                                Processing...Please wait.
                            </div>
                        </div>
                        <%--<div style="background-color: Gray; filter: alpha(opacity=50); opacity: 0.50; width: 100%; top: 0px; left: 0px; position: fixed;
                            height: 100%;">
                        </div>
                        <div style="margin: auto; font-family: Trebuchet MS; filter: alpha(opacity=100); opacity: 1; font-size: small; vertical-align: middle;
                            top: 45%; position: fixed; right: 45%; color: #232323; text-align: center; background-color: White; height: 100px;">
                            <table style="background-color: White; font-family: Sans-Serif; text-align: center; border: solid 1px #232323; color: #232323;
                                width: 300px; height: inherit; padding: 15px;">
                                <tr>
                                    <td style="text-align: inherit;">
                                        <img src="images/loading_image.gif" alt="Loading" title="Loading Image" />
                                    </td>
                                    <td style="text-align: inherit;">
                                        <span style="font-family: Sans-Serif; font-size: medium; font-weight: bold; font">Processing...Please wait.</span>
                                    </td>
                                </tr>
                            </table>
                        </div>--%>
                        <!-- End Modal Popup for Loading -->
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" TabIndex="1" HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td>
                                &nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label
                                    ID="LabelPatient" runat="server" SkinID="DataLabel" TabIndex="2"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" TabIndex="3"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIndex="4"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="MPAI-4" />
                <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <asp:Label ID="LabelInstrumentTitle" runat="server" Style="font-weight: bold" />&nbsp;-&nbsp;
                    <asp:LinkButton ID="lnkBtnToggleInstructions" runat="server" Text="Click for Instructions" ToolTip="Click to show/hide instructions."
                        OnClick="lnkBtnToggleInstructions_OnClick" TabIndex="5" />
                    <br />
                </asp:Panel>
                <!-- Instruction Area -->
                <asp:Panel ID="PanelInstructions" runat="server" Visible="false">
                    <br />
                    <div style="padding: 5px; width: 900px;">
                        <h2>
                            GENERAL INSTRUCTIONS</h2>
                        Please demonstrate each task and/or give instructions as written. When scoring, please record the lowest response category
                        that applies for each item.
                        <p>
                            Below each item, select the number that best describes the level at which the person being evaluated experiences problems. Mark the
                            greatest level of problem that is appropriate. Problems that interfere rarely with daily or valued activities, that is, less than 5% of the time,
                            should be considered not to interfere. Write comments about specific items at the end of the rating scale.</p>
                    </div>
                </asp:Panel>
                <!-- End Instruction Area -->
                
                <asp:Panel ID="PanelQuestions" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <!-- Question Area -->
                    <table style="width:100%;">
                        <tr>
                            <td style="width:250px;">
                                <%--Date:--%>
                                <!--Date-->
                                <!-- Get text in code-behind -->                                
                                <asp:Label ID="LabelDate1" runat="server" AssociatedControlID="dpDate1" SkinID="DataLabel" TabIndex="6">
                                </asp:Label> <span class="requiredField">*</span>
                            </td>
                            <td>
                                <!--Date picker-->
                                <telerik:RadDatePicker ID="dpDate1" runat="server" TabIndex="7">
                                    <Calendar ID="calDate1" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 1 required field validator (only one required)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDate1" TabIndex="8" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Date is required."></asp:RequiredFieldValidator>
                                <br />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <asp:Label ID="lblErrorQRPT1" runat="server" Text="" CssClass="requiredField"></asp:Label> 
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <asp:Label ID="LabelForQRPT" runat="server" AssociatedControlID="rblQRPT" SkinID="DataLabel" TabIndex="9">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <br />
                            </td>
                            <td>
                                <asp:RadioButtonList ID="rblQRPT" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQRPT" TabIndex="10"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList><%--<asp:Label ID="LabelForQRPT1" runat="server" AssociatedControlID="txtQRPT1" SkinID="DataLabel"></asp:Label>--%>
                                <asp:TextBox ID="txtQRPT1" runat="server"></asp:TextBox>
                                <br />
                                
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQRPT" runat="server" ControlToValidate="rblQRPT" TabIndex="11" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="QRPT selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQRPT" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQRPT" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQRPT" runat="server" Visible="false" Value="QRPT" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                    </table>
                    
                    
                    <table style="width:90%; margin-left:20px;">
                        <tr>
                            <td style="width: 15px;">
                                
                            </td>
                            <td>
                                <!-- Diagnosis Control -->
                                <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                                <VA:TbiDiagnosisSelector ID="ctrlDiagnosis" runat="server" QuestionNumber="DX" StartTabIndex="20" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <h3>Part A. Abilities</h3>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td style="width:15px;">
                                1
                            </td>
                            <td>

                                <asp:Label ID="LabelForQ1" runat="server" AssociatedControlID="rblQ1" SkinID="DataLabel" TabIndex="110">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ1" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ1" TabIndex="111"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ1" runat="server" ControlToValidate="rblQ1" TabIndex="112" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q1 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ1" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ1" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ1" runat="server" Visible="false" Value="1" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                2
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ2" runat="server" AssociatedControlID="rblQ2" SkinID="DataLabel" TabIndex="113">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ2" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ2" TabIndex="114"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ2" runat="server" ControlToValidate="rblQ2" TabIndex="115" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q2 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ2" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ2" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ2" runat="server" Visible="false" Value="2" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                3
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ3" runat="server" AssociatedControlID="rblQ3" SkinID="DataLabel" TabIndex="116">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ3" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ3" TabIndex="117"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ3" runat="server" ControlToValidate="rblQ3" TabIndex="118" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q3 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ3" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ3" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ3" runat="server" Visible="false" Value="3" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                4
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ4" runat="server" AssociatedControlID="rblQ4" SkinID="DataLabel" TabIndex="119">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ4" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ4" TabIndex="120"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ4" runat="server" ControlToValidate="rblQ4" TabIndex="121" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q4 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ4" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ4" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ4" runat="server" Visible="false" Value="4" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                5
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ5" runat="server" AssociatedControlID="rblQ5" SkinID="DataLabel" TabIndex="122">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ5" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ5" TabIndex="123"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ5" runat="server" ControlToValidate="rblQ5" TabIndex="124" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q5 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ5" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ5" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ5" runat="server" Visible="false" Value="5" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>                            
                        <tr>
                            <td>
                                6
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ6" runat="server" AssociatedControlID="rblQ6" SkinID="DataLabel" TabIndex="125">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ6" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ6" TabIndex="126"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ6" runat="server" ControlToValidate="rblQ6" TabIndex="127" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q6 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ6" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ6" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ6" runat="server" Visible="false" Value="6" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>  
                        <tr>
                            <td>
                                7A
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ7A" runat="server" AssociatedControlID="rblQ7A" SkinID="DataLabel" TabIndex="128">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ7A" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ7A" TabIndex="129"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ7A" runat="server" ControlToValidate="rblQ7A" TabIndex="130" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q7A selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ7A" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ7A" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ7A" runat="server" Visible="false" Value="7A" />
                            </td>
                        </tr> 
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                7B
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ7B" runat="server" AssociatedControlID="rblQ7B" SkinID="DataLabel" TabIndex="131">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ7B" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ7B" TabIndex="132"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ7B" runat="server" ControlToValidate="rblQ7B" TabIndex="133" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q7B selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ7B" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ7B" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ7B" runat="server" Visible="false" Value="7B" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                8
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ8" runat="server" AssociatedControlID="rblQ8" SkinID="DataLabel" TabIndex="134">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ8" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ8" TabIndex="135"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ8" runat="server" ControlToValidate="rblQ8" TabIndex="136" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q8 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ8" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ8" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ8" runat="server" Visible="false" Value="8" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr> 
                        <tr>
                            <td>
                                9
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ9" runat="server" AssociatedControlID="rblQ9" SkinID="DataLabel" TabIndex="137">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ9" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ9" TabIndex="138"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ9" runat="server" ControlToValidate="rblQ9" TabIndex="139" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q9 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ9" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ9" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ9" runat="server" Visible="false" Value="9" />
                            </td>
                        </tr> 
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                10
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ10" runat="server" AssociatedControlID="rblQ10" SkinID="DataLabel" TabIndex="141">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ10" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ10" TabIndex="142"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ10" runat="server" ControlToValidate="rblQ10" TabIndex="143" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q10 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ10" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ10" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ10" runat="server" Visible="false" Value="10" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                11
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ11" runat="server" AssociatedControlID="rblQ11" SkinID="DataLabel" TabIndex="144">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ11" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ11" TabIndex="145"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ11" runat="server" ControlToValidate="rblQ11" TabIndex="146" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q11 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ11" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ11" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ11" runat="server" Visible="false" Value="11" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                12
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ12" runat="server" AssociatedControlID="rblQ12" SkinID="DataLabel" TabIndex="147">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ12" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ12" TabIndex="148"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ12" runat="server" ControlToValidate="rblQ12" TabIndex="149" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q12 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ12" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ12" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ12" runat="server" Visible="false" Value="12" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <h3>Part B. Adjustment</h3>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        
                        <tr>
                            <td>
                                13
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ13" runat="server" AssociatedControlID="rblQ13" SkinID="DataLabel" TabIndex="161">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ13" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ13" TabIndex="162"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ13" runat="server" ControlToValidate="rblQ13" TabIndex="163" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q13 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ13" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ13" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ13" runat="server" Visible="false" Value="13" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                14
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ14" runat="server" AssociatedControlID="rblQ14" SkinID="DataLabel" TabIndex="164">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ14" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ14" TabIndex="165"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ14" runat="server" ControlToValidate="rblQ14" TabIndex="166" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q14 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ14" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ14" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ14" runat="server" Visible="false" Value="14" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                15
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ15" runat="server" AssociatedControlID="rblQ15" SkinID="DataLabel" TabIndex="167">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ15" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ15" TabIndex="168"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ15" runat="server" ControlToValidate="rblQ15" TabIndex="169" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q15 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ15" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ15" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ15" runat="server" Visible="false" Value="15" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                16
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ16" runat="server" AssociatedControlID="rblQ16" SkinID="DataLabel" TabIndex="171">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ16" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ16" TabIndex="172"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ16" runat="server" ControlToValidate="rblQ16" TabIndex="173" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q16 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ16" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ16" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ16" runat="server" Visible="false" Value="16" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                17
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ17" runat="server" AssociatedControlID="rblQ17" SkinID="DataLabel" TabIndex="174">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ17" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ17" TabIndex="175"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ17" runat="server" ControlToValidate="rblQ17" TabIndex="176" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q17 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ17" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ17" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ17" runat="server" Visible="false" Value="17" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                18
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ18" runat="server" AssociatedControlID="rblQ18" SkinID="DataLabel" TabIndex="177">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ18" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ18" TabIndex="178"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ18" runat="server" ControlToValidate="rblQ18" TabIndex="179" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q18 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ18" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ18" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ18" runat="server" Visible="false" Value="18" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                19
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ19" runat="server" AssociatedControlID="rblQ19" SkinID="DataLabel" TabIndex="181">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ19" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ19" TabIndex="182"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ19" runat="server" ControlToValidate="rblQ19" TabIndex="183" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q19 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ19" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ19" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ19" runat="server" Visible="false" Value="19" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                20
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ20" runat="server" AssociatedControlID="rblQ20" SkinID="DataLabel" TabIndex="184">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ20" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ20" TabIndex="185"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ20" runat="server" ControlToValidate="rblQ20" TabIndex="186" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q20 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ20" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ20" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ20" runat="server" Visible="false" Value="20" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                21
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ21" runat="server" AssociatedControlID="rblQ21" SkinID="DataLabel" TabIndex="187">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ21" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ21" TabIndex="188"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ21" runat="server" ControlToValidate="rblQ21" TabIndex="189" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q21 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ21" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ21" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ21" runat="server" Visible="false" Value="21" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <h3>Part C. Participation</h3>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                22
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ22" runat="server" AssociatedControlID="rblQ22" SkinID="DataLabel" TabIndex="190">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ22" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ22" TabIndex="191"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ22" runat="server" ControlToValidate="rblQ22" TabIndex="192" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q22 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ22" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ22" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ22" runat="server" Visible="false" Value="22" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                23
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ23" runat="server" AssociatedControlID="rblQ23" SkinID="DataLabel" TabIndex="193">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ23" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ23" TabIndex="194"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ23" runat="server" ControlToValidate="rblQ23" TabIndex="195" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q23 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ23" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ23" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ23" runat="server" Visible="false" Value="23" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                24
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ24" runat="server" AssociatedControlID="rblQ24" SkinID="DataLabel" TabIndex="196">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ24" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ24" TabIndex="197"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ24" runat="server" ControlToValidate="rblQ24" TabIndex="198" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q24 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ24" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ24" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ24" runat="server" Visible="false" Value="24" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                25
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ25" runat="server" AssociatedControlID="rblQ25" SkinID="DataLabel" TabIndex="211">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ25" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ25" TabIndex="212"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ25" runat="server" ControlToValidate="rblQ25" TabIndex="213" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q25 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ25" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ25" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ25" runat="server" Visible="false" Value="25" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                26
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ26" runat="server" AssociatedControlID="rblQ26" SkinID="DataLabel" TabIndex="214">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ26" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ26" TabIndex="215"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ26" runat="server" ControlToValidate="rblQ26" TabIndex="216" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q26 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ26" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ26" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ26" runat="server" Visible="false" Value="26" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                27
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ27" runat="server" AssociatedControlID="rblQ27" SkinID="DataLabel" TabIndex="217">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ27" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ27" TabIndex="218"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ27" runat="server" ControlToValidate="rblQ27" TabIndex="219" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q27 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ27" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ27" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ27" runat="server" Visible="false" Value="27" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <asp:Label ID="lblError28AB" runat="server" Text="" CssClass="requiredField"></asp:Label> 
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        
                        <tr>
                            <td>
                                28A
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ28A" runat="server" AssociatedControlID="rblQ28A" SkinID="DataLabel" TabIndex="221">
                                </asp:Label> <br />
                                <asp:RadioButtonList ID="rblQ28A" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ28A" TabIndex="222"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" AutoPostBack="true" OnSelectedIndexChanged="Q28aOnSelectedIndexChanged">
                                </asp:RadioButtonList>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ28A" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ28A" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ28A" runat="server" Visible="false" Value="28A" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                28B
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ28B" runat="server" AssociatedControlID="rblQ28B" SkinID="DataLabel" TabIndex="224">
                                </asp:Label> <br />
                                <asp:RadioButtonList ID="rblQ28B" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ28B" TabIndex="225"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" AutoPostBack="true" OnSelectedIndexChanged="Q28bOnSelectedIndexChanged">
                                </asp:RadioButtonList>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ28B" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ28B" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ28B" runat="server" Visible="false" Value="28B" />
                            </td>
                        </tr>
                        
                        <asp:PlaceHolder ID="plxhldrQ28B1" runat="server" Visible="true">
                            <tr>
                                <td colspan="100%">
                                    Other Employment - Social Role
                                </td>
                            </tr>
                            <tr>
                                <td>&nbsp;</td>
                                <td>
                                    <asp:Label ID="LabelForQ28B1" runat="server" AssociatedControlID="rblQ28B1" SkinID="DataLabel" TabIndex="227">
                                    </asp:Label> <br />
                                    <asp:RadioButtonList ID="rblQ28B1" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ28B1" TabIndex="228"
                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" AutoPostBack="false">
                                    </asp:RadioButtonList>
                                    <asp:ObjectDataSource ID="ObjectDataSourceQ28B1" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                        <SelectParameters>
                                            <asp:ControlParameter ControlID="HiddenQ28B1" Direction="Input" Name="questionNumber" Type="String" />
                                        </SelectParameters>
                                    </asp:ObjectDataSource>
                                    <asp:HiddenField ID="HiddenQ28B1" runat="server" Visible="false" Value="28B1" />
                                </td>
                            </tr>
                        </asp:PlaceHolder>
                        
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                29
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ29" runat="server" AssociatedControlID="rblQ29" SkinID="DataLabel" TabIndex="229">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ29" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ29" TabIndex="230"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ29" runat="server" ControlToValidate="rblQ29" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q29 selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ29" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ29" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ29" runat="server" Visible="false" Value="29" />
                            </td>
                        </tr>
                        
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <h3>Part D. Pre-existing and associated conditions.</h3>
                                The items below do not contribute to the total score but are used to identify special needs and circumstances. 
                                For each rate, pre-injury and post-injury status.
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                30PRE
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ30PRE" runat="server" AssociatedControlID="rblQ30PRE" SkinID="DataLabel" TabIndex="241">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ30PRE" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ30PRE" TabIndex="242"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ30PRE" runat="server" ControlToValidate="rblQ30PRE" TabIndex="243" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q30PRE selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ30PRE" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ30PRE" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ30PRE" runat="server" Visible="false" Value="30PRE" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                30POST
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ30POST" runat="server" AssociatedControlID="rblQ30POST" SkinID="DataLabel" TabIndex="244">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ30POST" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ30POST" TabIndex="245"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ30POST" runat="server" ControlToValidate="rblQ30POST" TabIndex="246" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q30POST selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ30POST" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ30POST" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ30POST" runat="server" Visible="false" Value="30POST" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                31PRE
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ31PRE" runat="server" AssociatedControlID="rblQ31PRE" SkinID="DataLabel" TabIndex="247">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ31PRE" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ31PRE" TabIndex="248"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ31PRE" runat="server" ControlToValidate="rblQ31PRE" TabIndex="249" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q31PRE selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ31PRE" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ31PRE" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ31PRE" runat="server" Visible="false" Value="31PRE" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                31POST
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ31POST" runat="server" AssociatedControlID="rblQ31POST" SkinID="DataLabel" TabIndex="251">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ31POST" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ31POST" TabIndex="252"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ31POST" runat="server" ControlToValidate="rblQ31POST" TabIndex="253" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q31POST selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ31POST" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ31POST" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ31POST" runat="server" Visible="false" Value="31POST" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                32PRE
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ32PRE" runat="server" AssociatedControlID="rblQ32PRE" SkinID="DataLabel" TabIndex="261">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ32PRE" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ32PRE" TabIndex="262"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ32PRE" runat="server" ControlToValidate="rblQ32PRE" TabIndex="263" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q32PRE selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ32PRE" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ32PRE" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ32PRE" runat="server" Visible="false" Value="32PRE" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                32POST
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ32POST" runat="server" AssociatedControlID="rblQ32POST" SkinID="DataLabel" TabIndex="271">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ32POST" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ32POST" TabIndex="272"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ32POST" runat="server" ControlToValidate="rblQ32POST" TabIndex="273" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q32POST selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ32POST" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ32POST" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ32POST" runat="server" Visible="false" Value="32POST" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                33PRE
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ33PRE" runat="server" AssociatedControlID="rblQ33PRE" SkinID="DataLabel" TabIndex="281">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ33PRE" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ33PRE" TabIndex="282"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ33PRE" runat="server" ControlToValidate="rblQ33PRE" TabIndex="283" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q33PRE selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ33PRE" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ33PRE" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ33PRE" runat="server" Visible="false" Value="33PRE" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                33POST
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ33POST" runat="server" AssociatedControlID="rblQ33POST" SkinID="DataLabel" TabIndex="284">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ33POST" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ33POST" TabIndex="285"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ33POST" runat="server" ControlToValidate="rblQ33POST" TabIndex="286" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q33POST selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ33POST" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ33POST" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ33POST" runat="server" Visible="false" Value="33POST" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                34PRE
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ34PRE" runat="server" AssociatedControlID="rblQ34PRE" SkinID="DataLabel" TabIndex="291">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ34PRE" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ34PRE" TabIndex="292"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ34PRE" runat="server" ControlToValidate="rblQ34PRE" TabIndex="293" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q34PRE selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ34PRE" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ34PRE" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ34PRE" runat="server" Visible="false" Value="34PRE" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                34POST
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ34POST" runat="server" AssociatedControlID="rblQ34POST" SkinID="DataLabel" TabIndex="294">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ34POST" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ34POST" TabIndex="295"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ34POST" runat="server" ControlToValidate="rblQ34POST" TabIndex="296" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q34POST selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ34POST" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ34POST" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ34POST" runat="server" Visible="false" Value="34POST" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                35PRE
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ35PRE" runat="server" AssociatedControlID="rblQ35PRE" SkinID="DataLabel" TabIndex="301">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ35PRE" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ35PRE" TabIndex="302"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ35PRE" runat="server" ControlToValidate="rblQ35PRE" TabIndex="303" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q35PRE selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ35PRE" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ35PRE" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ35PRE" runat="server" Visible="false" Value="35PRE" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                35POST
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ35POST" runat="server" AssociatedControlID="rblQ35POST" SkinID="DataLabel" TabIndex="304">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ35POST" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ35POST" TabIndex="305"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ35POST" runat="server" ControlToValidate="rblQ35POST" TabIndex="306" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Q35POST selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ35POST" runat="server" SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ35POST" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ35POST" runat="server" Visible="false" Value="35POST" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                36
                            </td>
                            <td>

                                <asp:Label ID="LabelForQ36Comment" runat="server" AssociatedControlID="txtCommentsQ36" SkinID="DataLabel" TabIndex="311">
                                </asp:Label>
                                <br />
                                <asp:TextBox ID="txtCommentsQ36" runat="server" MaxLength="1000" TextMode="MultiLine" Rows="4" Width="97%" TabIndex="312"></asp:TextBox>
                            </td>
                        </tr>
                        
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
        
                        <tr>
                            <td colspan="100%">
                                <asp:Button ID="btnCalculate" runat="server" Text="Calculate" OnClick="btnCalculate_Click" TabIndex="330" />
                                <br /><br />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <h3>Raw Scores</h3>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <!--Question 37: Abilities Subscale Score -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ37" runat="server" SkinID="DataLabel" TabIndex="331"></asp:Label>:&nbsp;    
                                <asp:Label ID="lblAbilitySubTotal" runat="server" Font-Bold="true" Text="0" TabIndex="332"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <!--Question 38: Adjustment Subscale Score -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ38" runat="server" SkinID="DataLabel" TabIndex="333"></asp:Label>:&nbsp;    
                                <asp:Label ID="lblAdjustmentSubTotal" runat="server" Font-Bold="true" Text="0" TabIndex="334"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <!--Question 39: Adjustment Subscale Score -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ39" runat="server" SkinID="DataLabel" TabIndex="335"></asp:Label>:&nbsp;    
                                <asp:Label ID="lblParticipationSubTotal" runat="server" Font-Bold="true" Text="0" TabIndex="336"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <!--Question 40: Subtotal of Subscale Scores -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ40" runat="server" SkinID="DataLabel" TabIndex="341"></asp:Label>:&nbsp;    
                                <asp:Label ID="lblSubtotalOfSubscaleScores" runat="server" Font-Bold="true" Text="0" TabIndex="341"></asp:Label>
                            </td>
                        </tr>        
                        <tr>
                            <td colspan="100%">
                                <!--Question 41: Sum of Scores for Q22-24 -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ41" runat="server" SkinID="DataLabel" TabIndex="345"></asp:Label>:&nbsp;    
                                <asp:Label ID="lblSumOfScoresQ22_24" runat="server" Font-Bold="true" Text="0" TabIndex="346"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <!--Question 42: Total Score -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ42" runat="server" SkinID="DataLabel" TabIndex="347"></asp:Label>:&nbsp;    
                                <asp:Label ID="lblTotalScore" runat="server" Font-Bold="true" Text="0" TabIndex="348"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <h3>Standard Scores</h3>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <!--Question 43: Abilities Standard Score -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ43" runat="server" SkinID="DataLabel" TabIndex="350"></asp:Label>:&nbsp;    
                                <asp:Label ID="lblAbilitiesStandardScore" runat="server" Font-Bold="true" Text="0" TabIndex="351"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <!--Question 44: Adjustment Standard Scores -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ44" runat="server" SkinID="DataLabel" TabIndex="353"></asp:Label>:&nbsp;    
                                <asp:Label ID="lblAdjustmentStandardScore" runat="server" Font-Bold="true" Text="0" TabIndex="354"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <!--Question 45: Participation Standard Score -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ45" runat="server" SkinID="DataLabel" TabIndex="355"></asp:Label>:&nbsp;    
                                <asp:Label ID="lblParticipationStandardScore" runat="server" Font-Bold="true" Text="0" TabIndex="356"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <!--Question 46: Total Standard Scores -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ46" runat="server" SkinID="DataLabel" TabIndex="357"></asp:Label>:&nbsp;    
                                <asp:Label ID="lblTotalStandardScore" runat="server" Font-Bold="true" Text="0" TabIndex="358"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <asp:Label ID="lblSurveyError" runat="server" TabIndex="359" CssClass="requiredField"></asp:Label>
                            </td>
                        </tr>                        

                    </table>
        
                    <!-- End Question Area -->
                    <br />
                </asp:Panel>
                <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
                    <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                </telerik:RadAjaxPanel>
                <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" Text="Save Draft" Width="130px" OnClick="btnSaveSurveyDraft_Click"
                    ValidationGroup="OnSaveDraft" TabIndex="360" />
                <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note" Width="180px" OnClick="btnSubmit_Click"
                    ValidationGroup="OnSave" TabIndex="361" />
                <asp:Button ID="btnCancelSurvey" runat="server" TabIndex="362" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>

